'The attached Code or Example is provided As Is.  
'It has not been tested or validated as a product, 
'for use in a deployed application or system, or for use in hazardous environments.  
'You assume all risks for use of the Code or Example.

Public Class Form1
    Dim inventory As MccDaq.DaqDeviceDescriptor()
    Public Daqboard As New MccDaq.MccBoard()
    Dim ulstat As MccDaq.ErrorInfo
    Dim Status As Boolean
    Public AIMhandle As IntPtr
    Dim AINumPoints As Integer
    Dim numpoints As Integer
    Dim numchannels As Integer
    Dim AInScanRange As MccDaq.Range
    Dim LastPass As String = "Upper"
    Public ADDataV() As Double
    Dim CurIndex As Integer
    Dim CurCount As Integer
    Dim AIStatus As Short
    Dim ChannelCount As Integer
    Dim MidScanPoint As Integer = 0

    Dim arrayindex As Integer
    Dim m2DRows As Integer
    Dim rows, cols As Integer
    Dim twoDData(,) As Double

    Const AllowedCharactersInt As String = "0123456789"
    Const AllowedCharactersFloat As String = "0123456789."

    Private Sub KeyPressService(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs, ByVal charSet As String)
        'this sub is here to make sure the user only enters an allowed character based upon the constants above.
        If Not charSet.Contains(e.KeyChar) AndAlso e.KeyChar <> ChrW(Keys.Back) Then
            e.Handled = True
        End If
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'First Lets make sure there's some kind of 1608G plugged in:
        MccDaq.DaqDeviceManager.IgnoreInstaCal() 'don't use information from InstaCal.

        System.Windows.Forms.Cursor.Current = Cursors.WaitCursor 'change cursor to wait.
        Dim Boardfound As Boolean = False

        'load all the boards it can find
        inventory = MccDaq.DaqDeviceManager.GetDaqDeviceInventory(MccDaq.DaqDeviceInterface.Any)
        Dim numDevDiscovered As Integer = inventory.Length 'how many was that?

        If numDevDiscovered > 0 Then
            For boardNum As Integer = 0 To numDevDiscovered - 1

                Try
                    '    Create a new MccBoard object for Board and assign a board number 
                    '    to the specified DAQ device with CreateDaqDevice()
                    Daqboard = MccDaq.DaqDeviceManager.CreateDaqDevice(boardNum, inventory(boardNum))

                    If Daqboard.BoardName.Contains("1608G") Then
                        Boardfound = True
                        Daqboard.FlashLED()
                        Exit For
                    Else
                        MccDaq.DaqDeviceManager.ReleaseDaqDevice(Daqboard)
                    End If
                Catch ule As MccDaq.ULException
                    MsgBox(ule.ErrorInfo.Message)
                End Try
            Next
        End If

        If Boardfound = False Then
            MsgBox("No USB-1608G series board found in system.  Please run InstaCal.", MsgBoxStyle.Critical, "No Board detected")
            End
        End If

        Dim mystring As String = Daqboard.BoardName.Substring(0, Daqboard.BoardName.Trim.Length) + _
            " found as board number: " + Daqboard.BoardNum.ToString
        Me.Text = mystring

        'Initialize some of the objects on the form
        LoadComboBox(cmboAInScanRange)
        AInScanRange = MccDaq.Range.Bip10Volts

        'Determine if the device is set for single ended or differential by the number of channels.
        Daqboard.BoardConfig.GetNumAdChans(numchannels)
        nudLowChannel.Maximum = numchannels - 1
        nudHighChannel.Maximum = numchannels - 1

    End Sub

    Private Sub btnAInStartStop_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAInStartStop.Click
        If btnAInStartStop.Text = "Start" Then
            btnAInStartStop.Text = "Stop"
            Status = True
            Me.Refresh()
            Call RunAdc()
        Else
            btnAInStartStop.Text = "Start"
            Status = False
            tmrAtoD.Enabled = False
            ulstat = Daqboard.StopBackground(MccDaq.FunctionType.AiFunction)
            If ulstat.Value <> MccDaq.ErrorInfo.ErrorCode.NoErrors Then Stop
            lblAIMode.Text = "Idle"
            ulstat = MccDaq.MccService.WinBufFreeEx(AIMhandle) ' Free up memory for use by other programs
            If ulstat.Value <> MccDaq.ErrorInfo.ErrorCode.NoErrors Then Stop
        End If
    End Sub

    Public Sub RunAdc()
        Dim AInOptions As MccDaq.ScanOptions
        Dim LowChannelNumber, HighChannelNumber As Integer
        Dim ADRate As Integer

        'read in the channel configuration, and check to make sure they are correct
        Integer.TryParse(nudLowChannel.Value, LowChannelNumber)
        Integer.TryParse(nudHighChannel.Value, HighChannelNumber)
        ChannelCount = HighChannelNumber - LowChannelNumber + 1
        If ChannelCount <= 0 Then
            MessageBox.Show(" Low channel selected is higher than High channel selected", "Invalid Channel Number ", _
            MessageBoxButtons.OK, MessageBoxIcon.Error)
            btnAInStartStop.Text = "Start"
            Exit Sub
        End If

        'read in the number of samples/channel,
        'create a buffer twice the size of number of channels * samples (minimum)
        'for example, if you want 1000 samples from 1 channel, the create a 2000 sample buffer.
        'see the notes in tmrAtoD_Tick for more details....
        Try
            Integer.TryParse(txtNumSamples.Text, AINumPoints)
            numpoints = AINumPoints
            AINumPoints = AINumPoints * ChannelCount * 2
        Catch ex As Exception
            MessageBox.Show(txtNumSamples.Text + " is not a valid rate value", "Invalid Rate Number ", _
                MessageBoxButtons.OK, MessageBoxIcon.Error)
            btnAInStartStop.Text = "Start"
            Exit Sub
        End Try

        'set up sample count and redim arrays
        ReDim ADDataV((ChannelCount) * (numpoints - 1))
        ReDim twoDData((ChannelCount - 1), (Math.Truncate(numpoints) - 1) / ChannelCount)

        ' set aside memory to hold data
        AIMhandle = MccDaq.MccService.ScaledWinBufAllocEx(AINumPoints)
        If AIMhandle = 0 Then Stop

        MidScanPoint = numpoints * ChannelCount

        'read in the sampling rate/channel
        Try
            Integer.TryParse(txtRate.Text, ADRate)
        Catch
            MessageBox.Show(txtRate.Text + " is not a valid number of points value", "Invalid count ", _
                MessageBoxButtons.OK, MessageBoxIcon.Error)
            btnAInStartStop.Text = "Start"
            Exit Sub
        End Try

        'read in the range
        AInScanRange = SelectRange(cmboAInScanRange.SelectedIndex)

        'Set scan options
        AInOptions = MccDaq.ScanOptions.Background + MccDaq.ScanOptions.ScaleData
        If chkContinuous.Checked = True Then AInOptions += MccDaq.ScanOptions.Continuous

        'Start the scan
        ulstat = Daqboard.AInScan(LowChannelNumber, HighChannelNumber, AINumPoints, _
             ADRate, AInScanRange, AIMhandle, AInOptions)
        If ulstat.Value <> MccDaq.ErrorInfo.ErrorCode.NoErrors Then
            errhandler(ulstat)
            Exit Sub
        End If

        'Start the timer
        tmrAtoD.Enabled = True

    End Sub

    Public Sub errhandler(ByVal ulstat As MccDaq.ErrorInfo)
        'Generic UL error handler
        MessageBox.Show(ulstat.Message, "Universal Library Error ", _
                   MessageBoxButtons.OK, MessageBoxIcon.Error)
        lblAIMode.Text = "Idle"
        btnAInStartStop.Text = "Start"
        ulstat = Daqboard.StopBackground(MccDaq.FunctionType.AiFunction)
        ulstat = MccDaq.MccService.WinBufFreeEx(AIMhandle) ' Free up memory for use by other programs
    End Sub

    Private Sub tmrAtoD_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tmrAtoD.Tick
        'The idea here is to ping pong between the lower half and upper half of the buffer, and 
        'check the where you are in the buffer often enough so you don't miss any.
        'This is accomplished by knowing where the midpoint is.  As we have a 2K sample buffer, the
        'mid point is at 1K samples.  so the program looks there to see where we are.
        'Additionally, as you don't want the same data repeatedly, we make sure only to take that part
        'of the buffer only once, by checking the 'LastPass' flag.
        'If we have crossed the midpoint and have not taken that data before then we
        '1. off load the new data. 
        '2. put the data back into a 2D array, 
        '3. Do something useful with the data.  Here the data is displayed in an Oscilloscope.

        'At every timer tick, we find out where we are, we do this by checking the CurIndex (current Index)
        ulstat = Daqboard.GetStatus(AIStatus, CurCount, CurIndex, MccDaq.FunctionType.AiFunction)
        If ulstat.Value <> MccDaq.ErrorInfo.ErrorCode.NoErrors Then
            errhandler(ulstat)
            Exit Sub
        End If

        lblAIShowCount.Text = CurCount.ToString()
        lblAICurIndex.Text = CurIndex.ToString()
        If AIStatus = MccDaq.MccBoard.Running Then lblAIMode.Text = "Running"

        'first find out if you are above or below the mid point of the total buffer 
        '(remember the 2x sized buffer?)
        'The data will stream in at 1000 samples per second, so you need to set the timer
        'to a rate that will let the program check the scan process at least twice as fast.
        'the minimum would be every 1/2 second.  This is so you don't miss any new data.
        'Here we have it set to 35mS, so we ping this many times.
        If CurIndex > MidScanPoint Then      'Find out where we are in the buffer, are we above the midpoint? 
            If AIMhandle = 0 Then Stop 'if yes then test if we have already obtained this data, 
            If LastPass = "Lower" And AIStatus = MccDaq.MccBoard.Running Then Exit Sub
            LastPass = "Lower" 'update the flag (to Lower) and get the lower half of the buffer
            'Copy the data to local array and convert to volts from counts.
            ulstat = MccDaq.MccService.ScaledWinBufToArray(AIMhandle, ADDataV, 0, MidScanPoint - 1)
            If ulstat.Value <> MccDaq.ErrorInfo.ErrorCode.NoErrors Then
                errhandler(ulstat)
                Exit Sub
            End If

        Else 'If the current index is in the lower half, then the upper half is ready to be used.
            'Test if we've been here before, and if so, exit and wait for the clock to tick.....
            If LastPass = "Upper" And AIStatus = MccDaq.MccBoard.Running Then Exit Sub
            LastPass = "Upper" 'if we've not been here before, then update the flag (to Upper), and get the upper
            'half of the buffer by copying in to local array and convert to volts from counts.
            ulstat = MccDaq.MccService.ScaledWinBufToArray(AIMhandle, ADDataV, MidScanPoint, MidScanPoint)
            If ulstat.Value <> MccDaq.ErrorInfo.ErrorCode.NoErrors Then
                errhandler(ulstat)
                Exit Sub
            End If
        End If


        'Data returned from 'ScaledWinBufToArray' is in an interleaved 1D array. The oscilloscope
        'requires the data to be in a 2D array so here is how to 
        'convert the data from a 1D array to a 2D array so it can be plotted
        For cols = 0 To ChannelCount - 1
            m2DRows = -1
            For rows = 0 To numpoints - ChannelCount Step ChannelCount
                arrayindex = cols + rows
                m2DRows += 1
                twoDData(cols, m2DRows) = ADDataV(arrayindex)
            Next
        Next

        'use the data. Here the data is displayed graphically.
        Oscilloscope11.UpdateScope(twoDData)    'twoDData is an array of new data to send to the oscilloscope.

        'what to do if the scan stops....
        If (AIStatus = MccDaq.MccBoard.Idle) Then
            btnAInStartStop.Text = "Start"
            Status = False
            tmrAtoD.Enabled = False
            ulstat = Daqboard.StopBackground(MccDaq.FunctionType.AiFunction)
            lblAIMode.Text = "Idle"
            ulstat = MccDaq.MccService.WinBufFreeEx(AIMhandle) ' Free up memory for use by other programs
            If ulstat.Value <> MccDaq.ErrorInfo.ErrorCode.NoErrors Then
                errhandler(ulstat)
                Exit Sub
            End If
        End If

    End Sub

    Private Sub btnEnd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnEnd.Click
        'How to end the program gracefully
        btnAInStartStop.Text = "Start"
        Status = False
        tmrAtoD.Enabled = False
        ulstat = Daqboard.StopBackground(MccDaq.FunctionType.AiFunction)
        lblAIMode.Text = "Idle"
        ulstat = MccDaq.MccService.WinBufFreeEx(AIMhandle) ' Free up memory for use by other programs
        End
    End Sub

    Public Function SelectRange(ByVal ComboBoxIndex As Int32) As Int32
        Dim AInScanRange As Int32

        Select Case ComboBoxIndex
            Case 0
                AInScanRange = Convert.ToInt32([Enum].Parse(GetType(MccDaq.Range), MccDaq.Range.Bip10Volts))
            Case 1
                AInScanRange = Convert.ToInt32([Enum].Parse(GetType(MccDaq.Range), MccDaq.Range.Bip5Volts))
            Case 2
                AInScanRange = Convert.ToInt32([Enum].Parse(GetType(MccDaq.Range), MccDaq.Range.Bip2Volts))
            Case 3
                AInScanRange = Convert.ToInt32([Enum].Parse(GetType(MccDaq.Range), MccDaq.Range.Bip1Volts))
        End Select

        Return AInScanRange
    End Function

    Public Sub LoadComboBox(ByVal sender As System.Object)
        With sender
            .Items.Add("BIP10VOLTS")
            .Items.Add("BIP5VOLTS")
            .Items.Add("BIP2VOLTS")
            .Items.Add("BIP1VOLTS")
            .SelectedIndex = 0
        End With
    End Sub

    Private Sub txtNumSamples_KeyPress(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtNumSamples.KeyPress
        KeyPressService(sender, e, AllowedCharactersInt)
    End Sub

    Private Sub txtRate_KeyPress(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtRate.KeyPress
        KeyPressService(sender, e, AllowedCharactersInt)
    End Sub

    Private Sub chkSeDiConfig_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkSeDiConfig.CheckedChanged
        If sender.checked Then
            sender.text = "Single Ended"
            Daqboard.AInputMode(MccDaq.AInputMode.SingleEnded)
        Else
            sender.text = "Differential"
            Daqboard.AInputMode(MccDaq.AInputMode.Differential)
        End If

        Daqboard.BoardConfig.GetNumAdChans(numchannels)
        nudLowChannel.Maximum = numchannels - 1
        nudHighChannel.Maximum = numchannels - 1
    End Sub
End Class
