'The attached Code or Example is provided As Is.  
'It has not been tested or validated as a product, 
'for use in a deployed application or system, or for use in hazardous environments.  
'You assume all risks for use of the Code or Example.

Public Class Form1

    Dim inventory As MccDaq.DaqDeviceDescriptor()
    Public Daqboard As New MccDaq.MccBoard()
    Dim ulstat As MccDaq.ErrorInfo
    Dim Status As Boolean
    Public AIMhandle As IntPtr
    Dim AINumPoints As Integer
    Dim numpoints As Integer
    Dim numchannels As Integer
    Dim LowChannelNumber, HighChannelNumber As Int32
    Dim AInScanRange As MccDaq.Range
    Dim AIFirstPoint As Integer
    Dim ChannelCount As Integer

    Dim arrayindex As Integer
    Dim m2DRows As Integer
    Dim rows, cols As Integer
    Dim twoDData(,) As Double

    Const AllowedCharactersInt As String = "0123456789"
    Const AllowedCharactersFloat As String = "0123456789."

    Private Sub KeyPressService(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs, ByVal charSet As String)

        If Not charSet.Contains(e.KeyChar) AndAlso e.KeyChar <> ChrW(Keys.Back) Then
            e.Handled = True
        End If

    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'First Lets make sure there's some kind of 1608G plugged in:
        MccDaq.DaqDeviceManager.IgnoreInstaCal() 'don't use information from InstaCal.

        System.Windows.Forms.Cursor.Current = Cursors.WaitCursor 'change cursor to wait.
        Dim Boardfound As Boolean = False

        'load all the boards it can find
        inventory = MccDaq.DaqDeviceManager.GetDaqDeviceInventory(MccDaq.DaqDeviceInterface.Any)

        Dim numDevDiscovered As Integer = inventory.Length 'how many was that?

        If numDevDiscovered > 0 Then
            For boardNum As Integer = 0 To numDevDiscovered - 1

                Try
                    '    Create a new MccBoard object for Board and assign a board number 
                    '    to the specified DAQ device with CreateDaqDevice()
                    Daqboard = MccDaq.DaqDeviceManager.CreateDaqDevice(boardNum, inventory(boardNum))

                    If Daqboard.BoardName.Contains("1608G") Then
                        Boardfound = True
                        Daqboard.FlashLED()
                        Exit For
                    Else
                        MccDaq.DaqDeviceManager.ReleaseDaqDevice(Daqboard)
                    End If
                Catch ule As MccDaq.ULException
                    MsgBox(ule.ErrorInfo.Message)
                End Try
            Next
        End If

        If Boardfound = False Then
            MsgBox("No USB-1608G series board found in system.  Please run InstaCal.", MsgBoxStyle.Critical, "No Board detected")
            End
        End If

        Dim mystring As String = Daqboard.BoardName.Substring(0, Daqboard.BoardName.Trim.Length) + _
            " found as board number: " + Daqboard.BoardNum.ToString
        Me.Text = mystring

        LoadComboBox(cmbAInScanRange)
        AInScanRange = MccDaq.Range.Bip10Volts

        'Determine if the device is set for single ended or differential by the number of channels.
        Daqboard.BoardConfig.GetNumAdChans(numchannels)

    End Sub

    Private Sub btnAInStartStop_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAInStartStop.Click
        If btnAInStartStop.Text = "Start" Then
            btnAInStartStop.Text = "Stop"
            Status = True
            Me.Refresh()
            Call RunAdc()
        Else
            btnAInStartStop.Text = "Start"
            Status = False
            ulstat = Daqboard.StopBackground(MccDaq.FunctionType.AiFunction)
            If ulstat.Value <> MccDaq.ErrorInfo.ErrorCode.NoErrors Then Stop
            lblAIMode.Text = "Idle"
            ulstat = MccDaq.MccService.WinBufFreeEx(AIMhandle) ' Free up memory for use by other programs
            If ulstat.Value <> MccDaq.ErrorInfo.ErrorCode.NoErrors Then Stop
        End If
    End Sub

    Public Sub RunAdc()
        Dim AInOptions As MccDaq.ScanOptions

        Try
            Integer.TryParse(nudLowChannel.Value, LowChannelNumber)
        Catch
            MessageBox.Show(txtRate.Text + " is not a valid Low Channel Number value", "Invalid Channel Number ", _
            MessageBoxButtons.OK, MessageBoxIcon.Error)

        End Try

        Try
            Integer.TryParse(nudHighChannel.Value, HighChannelNumber)
        Catch
            MessageBox.Show(txtRate.Text + " is not a valid High Channel Number value", "Invalid Channel Number ", _
            MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try

        'set up sample count and redim arrays
        ChannelCount = HighChannelNumber - LowChannelNumber + 1

        Try
            Integer.TryParse(txtNumSamples.Text, AINumPoints)
            numpoints = AINumPoints
            AINumPoints = AINumPoints * ChannelCount
        Catch ex As Exception
            MessageBox.Show(txtNumSamples.Text + " is not a valid rate value", "Invalid Rate Number ", _
                        MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try

        Dim ADRate As Int32
        Try
            Integer.TryParse(txtRate.Text, ADRate)
        Catch
            MessageBox.Show(txtRate.Text + " is not a valid number of points value", "Invalid count ", _
            MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try

        AInScanRange = SelectRange(cmbAInScanRange.SelectedIndex)

        ' set aside memory to hold data
        AIMhandle = MccDaq.MccService.ScaledWinBufAllocEx(AINumPoints)
        If AIMhandle = 0 Then Stop

        AIFirstPoint = 0

        'Set scan options
        AInOptions = MccDaq.ScanOptions.ScaleData

        'Start the scan
        lblAIMode.Text = "Running"
        lblAIMode.Refresh()
        ulstat = Daqboard.AInScan(LowChannelNumber, HighChannelNumber, AINumPoints, _
             ADRate, AInScanRange, AIMhandle, AInOptions)
        If ulstat.Value <> MccDaq.ErrorInfo.ErrorCode.NoErrors Then
            errhandler(ulstat)
            Exit Sub
        End If

        ConvertData()

    End Sub

    Public Sub errhandler(ByVal ulstat As MccDaq.ErrorInfo)
        'Generic UL error handler
        MessageBox.Show(ulstat.Message, "Universal Library Error ", _
                   MessageBoxButtons.OK, MessageBoxIcon.Error)
        lblAIMode.Text = "Idle"
        btnAInStartStop.Text = "Start"
        ulstat = Daqboard.StopBackground(MccDaq.FunctionType.AiFunction)
        ulstat = MccDaq.MccService.WinBufFreeEx(AIMhandle) ' Free up memory for use by other programs
    End Sub

    Public Sub ConvertData()
        'Do something useful with the data.
        'Here the data is plotted in an oscilloscope.

        Dim ADDataV((ChannelCount) * (AINumPoints - 1)) As Double
        ReDim twoDData((ChannelCount - 1), (Math.Truncate(numpoints / ChannelCount) - 1))
        ulstat = MccDaq.MccService.ScaledWinBufToArray(AIMhandle, ADDataV, AIFirstPoint, numpoints)

        'Data returned from 'ScaledWinBufToArray' is in an interleaved 1D array. The oscilloscope
        'requires the data to be in a 2D array so here is how to 
        'convert the data from a 1D array to a 2D array so it can be plotted
        For cols = 0 To ChannelCount - 1
            m2DRows = -1
            For rows = 0 To numpoints - ChannelCount Step ChannelCount
                arrayindex = cols + rows
                m2DRows += 1
                twoDData(cols, m2DRows) = ADDataV(arrayindex)
            Next
        Next
        Oscilloscope11.UpdateScope(twoDData)     'twoDData is an array of new data to send to the oscilloscope.

        btnAInStartStop.Text = "Start"
        ulstat = Daqboard.StopBackground(MccDaq.FunctionType.AiFunction)
        lblAIMode.Text = "Idle"
        ulstat = MccDaq.MccService.WinBufFreeEx(AIMhandle) ' Free up memory for use by other programs
        If ulstat.Value <> MccDaq.ErrorInfo.ErrorCode.NoErrors Then
            errhandler(ulstat)
            Exit Sub
        End If

    End Sub

    Private Sub btnEnd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnEnd.Click
        btnAInStartStop.Text = "Start"
        Status = False
        ulstat = Daqboard.StopBackground(MccDaq.FunctionType.AiFunction)
        lblAIMode.Text = "Idle"
        ulstat = MccDaq.MccService.WinBufFreeEx(AIMhandle) ' Free up memory for use by other programs
        End
    End Sub

    Public Function SelectRange(ByVal ComboBoxIndex As Int32) As Int32

        Dim AInScanRange As Int32
        Select Case ComboBoxIndex
            Case 0
                AInScanRange = Convert.ToInt32([Enum].Parse(GetType(MccDaq.Range), MccDaq.Range.Bip10Volts))
            Case 1
                AInScanRange = Convert.ToInt32([Enum].Parse(GetType(MccDaq.Range), MccDaq.Range.Bip5Volts))
            Case 2
                AInScanRange = Convert.ToInt32([Enum].Parse(GetType(MccDaq.Range), MccDaq.Range.Bip2Volts))
            Case 3
                AInScanRange = Convert.ToInt32([Enum].Parse(GetType(MccDaq.Range), MccDaq.Range.Bip1Volts))
        End Select

        Return AInScanRange

    End Function

    Private Sub txtRate_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtRate.KeyPress
        KeyPressService(sender, e, AllowedCharactersInt)
    End Sub

    Public Sub LoadComboBox(ByVal sender As System.Object)
        With sender
            .Items.Add("BIP10VOLTS")
            .Items.Add("BIP5VOLTS")
            .Items.Add("BIP2VOLTS")
            .Items.Add("BIP1VOLTS")
            .SelectedIndex = 0
        End With
    End Sub

    Private Sub txtLowChannel_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs)
        KeyPressService(sender, e, AllowedCharactersInt)
    End Sub

    Private Sub txtHighChannel_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs)
        KeyPressService(sender, e, AllowedCharactersInt)
    End Sub

    Private Sub chkSeDiConfig_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkSeDiConfig.CheckedChanged
        If sender.checked Then
            sender.text = "Single Ended"
            Daqboard.AInputMode(MccDaq.AInputMode.SingleEnded)
        Else
            sender.text = "Differential"
            Daqboard.AInputMode(MccDaq.AInputMode.Differential)
        End If

        Daqboard.BoardConfig.GetNumAdChans(numchannels)
        nudLowChannel.Maximum = numchannels - 1
        nudHighChannel.Maximum = numchannels - 1
    End Sub
End Class
