'The attached Code or Example is provided As Is.  
'It has not been tested or validated as a product, 
'for use in a deployed application or system, or for use in hazardous environments.  
'You assume all risks for use of the Code or Example.

Public Class Form1
    Dim inventory As MccDaq.DaqDeviceDescriptor()
    Public Daqboard As New MccDaq.MccBoard()
    Dim ulstat As MccDaq.ErrorInfo
    Dim Status As Boolean

    Dim AIMyData As Single
    Dim AInRange As MccDaq.Range
    Dim numchannels As Integer

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'First Lets make sure there's some kind of 1608G plugged in:
        MccDaq.DaqDeviceManager.IgnoreInstaCal() 'don't use information from InstaCal.

        System.Windows.Forms.Cursor.Current = Cursors.WaitCursor 'change cursor to wait.
        Dim Boardfound As Boolean = False

        'load all the boards it can find
        inventory = MccDaq.DaqDeviceManager.GetDaqDeviceInventory(MccDaq.DaqDeviceInterface.Any)

        Dim numDevDiscovered As Integer = inventory.Length 'how many was that?

        If numDevDiscovered > 0 Then
            For boardNum As Integer = 0 To numDevDiscovered - 1

                Try
                    '    Create a new MccBoard object for Board and assign a board number 
                    '    to the specified DAQ device with CreateDaqDevice()
                    Daqboard = MccDaq.DaqDeviceManager.CreateDaqDevice(boardNum, inventory(boardNum))

                    If Daqboard.BoardName.Contains("1608G") Then
                        Boardfound = True
                        Daqboard.FlashLED()
                        Exit For
                    Else
                        MccDaq.DaqDeviceManager.ReleaseDaqDevice(Daqboard)
                    End If
                Catch ule As MccDaq.ULException
                    MsgBox(ule.ErrorInfo.Message)
                End Try
            Next
        End If

        If Boardfound = False Then
            MsgBox("No USB-1608G series board found in system.  Please run InstaCal.", MsgBoxStyle.Critical, "No Board detected")
            End
        End If

        Dim mystring As String = Daqboard.BoardName.Substring(0, Daqboard.BoardName.Trim.Length) + _
            " found as board number: " + Daqboard.BoardNum.ToString
        Me.Text = mystring

        LoadComboBox(cmboAInRange)
        cmboAInRange.SelectedIndex = 0
        AInRange = SelectRange(cmboAInRange.SelectedIndex)


        'Determine if the device is set for single ended or differential by the number of channels.
        Daqboard.BoardConfig.GetNumAdChans(numchannels)
        nudAInChannel.Maximum = numchannels

        'set up sample timing
        Dim i As Integer
        For i = 1 To 10
            cbRate.Items.Add(i)
        Next
        cbRate.SelectedIndex = 9

    End Sub

    Private Sub Button6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button6.Click
        End
    End Sub

    Public Function SelectRange(ByVal ComboBoxIndex As Int32) As Int32

        Dim AInRange As Int32
        Select Case ComboBoxIndex
            Case 0
                AInRange = Convert.ToInt32([Enum].Parse(GetType(MccDaq.Range), MccDaq.Range.Bip10Volts))
            Case 1
                AInRange = Convert.ToInt32([Enum].Parse(GetType(MccDaq.Range), MccDaq.Range.Bip5Volts))
            Case 2
                AInRange = Convert.ToInt32([Enum].Parse(GetType(MccDaq.Range), MccDaq.Range.Bip2Volts))
            Case 3
                AInRange = Convert.ToInt32([Enum].Parse(GetType(MccDaq.Range), MccDaq.Range.Bip1Volts))
        End Select

        Return AInRange

    End Function

    Public Sub LoadComboBox(ByVal sender As System.Object)
        With sender
            .Items.Add("BIP10VOLTS")
            .Items.Add("BIP5VOLTS")
            .Items.Add("BIP2VOLTS")
            .Items.Add("BIP1VOLTS")
            .SelectedIndex = 0
        End With
    End Sub


    Private Sub btnStartStop_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnStartStop.Click
        If sender.Text = "Start" Then
            sender.Text = "Stop"
            lblAIMode.Text = "Running"
            sender.refresh()
            tmrAnalogIn.Interval = 1000 / cbRate.SelectedItem
            StripChart1.TimeInterval = tmrAnalogIn.Interval
            StripChart1.XTicks = 5
            StripChart1.Reset()
            tmrAnalogIn.Enabled = True
        Else
            sender.Text = "Start"
            lblAIMode.Text = "Idle"
            tmrAnalogIn.Enabled = False
        End If
    End Sub

    Private Sub tmrAnalogIn_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tmrAnalogIn.Tick
        Dim VInVolts As Double

        AInRange = SelectRange(cmboAInRange.SelectedIndex)

        ulstat = Daqboard.VIn32(Convert.ToInt16(nudAInChannel.Value), AInRange, VInVolts, MccDaq.VInOptions.Default)
        If ulstat.Value <> MccDaq.ErrorInfo.ErrorCode.NoErrors Then
            errhandler(ulstat)
            Exit Sub
        End If

        StripChart1.AddValue(VInVolts)

    End Sub

    Public Sub errhandler(ByVal ulstat As MccDaq.ErrorInfo)
        'Generic UL error handler
        tmrAnalogIn.Enabled = False
        MessageBox.Show(ulstat.Message, "Universal Library Error ", MessageBoxButtons.OK, MessageBoxIcon.Error)
        lblAIMode.Text = "Idle"
        btnStartStop.Text = "Start"
    End Sub

    Private Sub Label2_Click(sender As System.Object, e As System.EventArgs) Handles Label2.Click

    End Sub

    Private Sub chkSeDiConfig_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkSeDiConfig.CheckedChanged
        If sender.checked Then
            sender.text = "Single Ended"
            Daqboard.AInputMode(MccDaq.AInputMode.SingleEnded)
        Else
            sender.text = "Differential"
            Daqboard.AInputMode(MccDaq.AInputMode.Differential)
        End If

        Daqboard.BoardConfig.GetNumAdChans(numchannels)
        nudAInChannel.Maximum = numchannels - 1
    End Sub
End Class
