﻿'The attached Code or Example is provided As Is.  
'It has not been tested or validated as a product, 
'for use in a deployed application or system, or for use in hazardous environments.  
'You assume all risks for use of the Code or Example.

Public Class Form1
    Dim IsFormLoaded As Boolean = False

    Dim inventory As MccDaq.DaqDeviceDescriptor()

    Public Daqboard As New MccDaq.MccBoard()
    Dim ulstat As MccDaq.ErrorInfo
    Public Range As MccDaq.Range

    Const AllowedCharactersInt As String = "0123456789"
    Const AllowedCharactersFloat As String = "-0123456789."

    Private Sub KeyPressService(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs, ByVal charSet As String)
        'this sub is here to make sure the user only enters an allowed character based upon the constants above.
        If Not charSet.Contains(e.KeyChar) AndAlso e.KeyChar <> ChrW(Keys.Back) Then
            e.Handled = True
        End If
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'First Lets make sure there's some kind of 1608G plugged in:
        MccDaq.DaqDeviceManager.IgnoreInstaCal() 'don't use information from InstaCal.

        System.Windows.Forms.Cursor.Current = Cursors.WaitCursor 'change cursor to wait.
        Dim Boardfound As Boolean = False

        'load all the boards it can find
        inventory = MccDaq.DaqDeviceManager.GetDaqDeviceInventory(MccDaq.DaqDeviceInterface.Any)

        Dim numDevDiscovered As Integer = inventory.Length 'how many was that?

        If numDevDiscovered > 0 Then
            For boardNum As Integer = 0 To numDevDiscovered - 1

                Try
                    '    Create a new MccBoard object for Board and assign a board number 
                    '    to the specified DAQ device with CreateDaqDevice()
                    Daqboard = MccDaq.DaqDeviceManager.CreateDaqDevice(boardNum, inventory(boardNum))

                    If Daqboard.BoardName.Contains("1608G") Then
                        Boardfound = True
                        Daqboard.FlashLED()
                        Exit For
                    Else
                        MccDaq.DaqDeviceManager.ReleaseDaqDevice(Daqboard)
                    End If
                Catch ule As MccDaq.ULException
                    MsgBox(ule.ErrorInfo.Message)
                End Try
            Next
        End If

        If Boardfound = False Then
            MsgBox("No USB-1608G series board found in system.  Please run InstaCal.", MsgBoxStyle.Critical, "No Board detected")
            End
        End If

        Dim mystring As String = Daqboard.BoardName.Substring(0, Daqboard.BoardName.Trim.Length) + _
            " found as board number: " + Daqboard.BoardNum.ToString
        Me.Text = mystring

        'make sure this device has analog outputs.
        If (Not Daqboard.BoardName.Contains("2AO")) Then
            System.Windows.Forms.MessageBox.Show("The USB-1608G Series you have does not have analog output capabilities.  You must use a USB-1608GX-2AO for this program.  " _
               + "This program will now terminate.", "Wrong model USB-1608G")
            End
        End If

    End Sub

    Private Sub btnEnd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnEnd.Click
        'Return the DACs to their initial output values of 0VDC on exit
        ulstat = Daqboard.VOut(Convert.ToInt16(nudChannelNumber.Value), MccDaq.Range.Bip10Volts, 0, MccDaq.VOutOptions.Default)
        ulstat = Daqboard.VOut(Convert.ToInt16(nudChannelNumber.Value), MccDaq.Range.Bip10Volts, 1, MccDaq.VOutOptions.Default)
        End
    End Sub

    Private Sub txtVoltsOut_KeyPress(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtVoltsOut.KeyPress
        KeyPressService(sender, e, AllowedCharactersFloat)
        If e.KeyChar = ChrW(Keys.Enter) Then

            'Output 1 value to a DAC using the VOut() method
            If (Val(txtVoltsOut.Text) <= 10) And (Val(txtVoltsOut.Text) >= -10) Then
                ulstat = Daqboard.VOut(Convert.ToInt16(nudChannelNumber.Value), MccDaq.Range.Bip10Volts, _
                    Convert.ToSingle(txtVoltsOut.Text), MccDaq.VOutOptions.Default)
                lblStatus.Text = "Status  " + ulstat.Message
                KnobDial1.UpdateKnob(Convert.ToSingle(txtVoltsOut.Text)) 'update the knob to keep it in sync.
            Else
                System.Windows.Forms.MessageBox.Show("Value entered in TxtVoltsOut is larger than +/-10, please enter a correct value", _
                            "Value out of range")
                txtVoltsOut.Text = ""
            End If
        End If
    End Sub

    Private Sub KnobDial1_ReadKnobValue(ByVal dKnobValue As Double) Handles KnobDial1.ReadKnobValue
        ulstat = Daqboard.VOut(Convert.ToInt16(nudChannelNumber.Value), MccDaq.Range.Bip10Volts, _
               Convert.ToSingle(dKnobValue), MccDaq.VOutOptions.Default)
        lblStatus.Text = "Status  " + ulstat.Message

        txtVoltsOut.Text = dKnobValue.ToString("##.000")
    End Sub
End Class
