'The attached Code or Example is provided As Is.  
'It has not been tested or validated as a product, 
'for use in a deployed application or system, or for use in hazardous environments.  
'You assume all risks for use of the Code or Example.

Public Class Form1

    Dim inventory As MccDaq.DaqDeviceDescriptor()
    Public Daqboard As New MccDaq.MccBoard()
    Dim ulstat As MccDaq.ErrorInfo
    Dim Status As Boolean
    Dim MHandle As IntPtr
    Dim DataArray() As UShort
    Public ADDataV(,) As Object
    Dim NumPoints As Integer

    Dim FirstPoint As Integer
    Dim CurIndex As Integer
    Dim CurCount As Integer

    Const AllowedCharactersInt As String = "0123456789"
    Const AllowedCharactersFloat As String = "0123456789."

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'First Lets make sure there's some kind of 1608G plugged in:
        MccDaq.DaqDeviceManager.IgnoreInstaCal() 'don't use information from InstaCal.

        System.Windows.Forms.Cursor.Current = Cursors.WaitCursor 'change cursor to wait.
        Dim Boardfound As Boolean = False

        'load all the boards it can find
        inventory = MccDaq.DaqDeviceManager.GetDaqDeviceInventory(MccDaq.DaqDeviceInterface.Any)

        Dim numDevDiscovered As Integer = inventory.Length 'how many was that?

        If numDevDiscovered > 0 Then
            For boardNum As Integer = 0 To numDevDiscovered - 1

                Try
                    '    Create a new MccBoard object for Board and assign a board number 
                    '    to the specified DAQ device with CreateDaqDevice()
                    Daqboard = MccDaq.DaqDeviceManager.CreateDaqDevice(boardNum, inventory(boardNum))

                    If Daqboard.BoardName.Contains("1608G") Then
                        Boardfound = True
                        Daqboard.FlashLED()
                        Exit For
                    Else
                        MccDaq.DaqDeviceManager.ReleaseDaqDevice(Daqboard)
                    End If
                Catch ule As MccDaq.ULException
                    MsgBox(ule.ErrorInfo.Message)
                End Try
            Next
        End If

        If Boardfound = False Then
            MsgBox("No USB-1608G series board found in system.  Please run InstaCal.", MsgBoxStyle.Critical, "No Board detected")
            End
        End If

        Dim mystring As String = Daqboard.BoardName.Substring(0, Daqboard.BoardName.Trim.Length) + _
            " found as board number: " + Daqboard.BoardNum.ToString
        Me.Text = mystring

        'make sure this device has analog outputs.
        If (Not Daqboard.BoardName.Contains("2AO")) Then
            System.Windows.Forms.MessageBox.Show("The USB-1608G Series you have does not have analog output capabilities.  You must use a USB-1608GX-2AO for this program.  " _
               + "This program will now terminate.", "Wrong model USB-1608G")
            End
        End If

        Me.nudChannelNumber.Maximum = 1

    End Sub

    Private Sub btnStartStop_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnStartStop.Click
        If btnStartStop.Text = "Start" Then
            btnStartStop.Text = "Stop"
            Status = True
            Me.Refresh()
            DisableObjects()
            Call RunDacs()
        Else
            btnStartStop.Text = "Start"
            Status = False
            ulstat = Daqboard.StopBackground(MccDaq.FunctionType.AoFunction)
            lblMode.Text = "Idle"
            ulstat = MccDaq.MccService.WinBufFreeEx(MHandle) ' Free up memory for use by other programs
            EnableObjects()
        End If
    End Sub

    Public Sub RunDacs()
        Dim i As Integer
        Dim MaxDacValue, DCOffset As Int16
        Dim dblDutyCycle As Double
        Dim AORate As Int32
        Dim intCurrentChannel As Integer = 0
        Dim intPointsPerWaveform As Integer
        Dim OutputChannel As Integer

        'Here we are generating the data array of a predetermined waveform type to output. 
        'you can skip down to the line of ''''''''''' for the syntax 
        'that controls the scan

        FunctionGenerator1.NumberOfChannels = (1)

        Try     'amplitude of waveform
            Single.TryParse(txtAmplitude.Text, MaxDacValue)
            FunctionGenerator1.amplitude(MaxDacValue)
        Catch
            MessageBox.Show(txtAmplitude.Text + " is not a valid Amplitude", "Invalid Amplitude ", _
            MessageBoxButtons.OK, MessageBoxIcon.Error)
            btnStartStop.Text = "Start"
            Exit Sub
        End Try

        Try     'offset of waveform
            Single.TryParse(txtOffset.Text, DCOffset)
            FunctionGenerator1.offset(DCOffset)
        Catch
            MessageBox.Show(txtOffset.Text + " is not a valid Offset", "Invalid Offset ", _
            MessageBoxButtons.OK, MessageBoxIcon.Error)
            btnStartStop.Text = "Start"
            Exit Sub
        End Try

        Try     'number of point per period
            Integer.TryParse(txtPointsPerWaveform.Text, intPointsPerWaveform)
            FunctionGenerator1.PointsPerPeriod(intPointsPerWaveform)
            NumPoints = intPointsPerWaveform
            ReDim ADDataV(0, NumPoints - 1)
            ReDim DataArray(NumPoints - 1)
        Catch
            MessageBox.Show(txtOffset.Text + " is not a valid Points/Waveform", "Invalid Points/Waveform ", _
            MessageBoxButtons.OK, MessageBoxIcon.Error)
            btnStartStop.Text = "Start"
            Exit Sub
        End Try

        Try     ' Duty Cycle - only for Squarewave
            Single.TryParse(txtDutyCycle.Text, dblDutyCycle)
            FunctionGenerator1.DutyCycle(dblDutyCycle)  ', intCurrentChannel)
        Catch
            MessageBox.Show(txtDutyCycle.Text + " is not a valid DutyCycle", "Invalid DutyCycle ", _
            MessageBoxButtons.OK, MessageBoxIcon.Error)
            btnStartStop.Text = "Start"
            Exit Sub
        End Try

        Try     'get the rate of the output
            AORate = Int32.Parse(txtAORate.Text)
        Catch
            MessageBox.Show(txtAORate.Text + " is not a valid Rate", "Invalid Rate ", _
            MessageBoxButtons.OK, MessageBoxIcon.Error)
            btnStartStop.Text = "Start"
            tmrOutScan.Enabled = False
            Exit Sub
        End Try

        Integer.TryParse(nudChannelNumber.Value, OutputChannel)

        Select Case True     'select a predetermined wavetype
            Case rbNoiseWave.Checked
                FunctionGenerator1.WaveSelect(BERGtools.WaveType.Noise, 0)
            Case rbRampWave.Checked
                FunctionGenerator1.WaveSelect(BERGtools.WaveType.Ramp, 0)
            Case rbSineWave.Checked
                FunctionGenerator1.WaveSelect(BERGtools.WaveType.Sine, 0)
            Case rbSquareWave.Checked
                FunctionGenerator1.WaveSelect(BERGtools.WaveType.Square, 0)
            Case rbTriangleWave.Checked
                FunctionGenerator1.WaveSelect(BERGtools.WaveType.Triangle, 0)
        End Select

        ADDataV = FunctionGenerator1.CreateWave   'create the waveform using FunctionGenerator class

        For i = 0 To NumPoints - 1     'convert to counts from volts
            ulstat = Daqboard.FromEngUnits(MccDaq.Range.Bip10Volts, ADDataV(0, i), DataArray(i))
        Next

        Oscilloscope11.UpdateScope(ADDataV)  'display 1 period of the waveform to be sent out.

        '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
        'Look here to see how to Load the array, set options and start the scan
        MHandle = MccDaq.MccService.WinBufAllocEx(NumPoints) ' set aside memory to hold data
        If MHandle = 0 Then Stop

        FirstPoint = 0
        Me.lblMode.Text = "Running"


        'move the array out to computer memory
        ulstat = MccDaq.MccService.WinArrayToBuf(DataArray, MHandle, FirstPoint, NumPoints)

        'Set scan options
        Dim AOOptions As MccDaq.ScanOptions = MccDaq.ScanOptions.Default
        If chkAOBackground.Checked Then AOOptions += MccDaq.ScanOptions.Background
        If chkAOContinuous.Checked Then AOOptions += MccDaq.ScanOptions.Continuous
        If chkExtTrigger.Checked Then AOOptions += MccDaq.ScanOptions.ExtTrigger
        If chkExtClock.Checked Then AOOptions += MccDaq.ScanOptions.ExtClock

        'Start the output scan
        ulstat = Daqboard.AOutScan(OutputChannel, OutputChannel, NumPoints, AORate, MccDaq.Range.Bip10Volts, MHandle, AOOptions)
        If ulstat.Value <> MccDaq.ErrorInfo.ErrorCode.NoErrors Then
            errhandler(ulstat)
        End If

        ulstat = Daqboard.GetStatus(Status, CurCount, CurIndex, MccDaq.FunctionType.AoFunction)

        'once the scan is running, check the timer for status.
        tmrOutScan.Enabled = True

    End Sub

    Private Sub Timer2_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tmrOutScan.Tick
        'Look here to check the status of the scan.
        'You can check to see if it's still running from the Status parameter (True = running)
        'Current Count will tell you the number of samples you have output (totalizer)
        'Current Index will tell you where you are in your array. 
        'Note that if the array is one packet in length, you will never see it change.
        ulstat = Daqboard.GetStatus(Status, CurCount, CurIndex, MccDaq.FunctionType.AoFunction)
        lblCurIndex.Text = CurIndex.ToString()

        'If you are running in Background only status will change to false as soon
        'as the CurIndex = numpoints (length of the buffer)
        'In Foreground mode, this event is not necessary as the program will wait until the scan completes.
        If Status = False Then
            tmrOutScan.Enabled = False
            btnStartStop.Text = "Start"
            Status = False
            ulstat = Daqboard.StopBackground(MccDaq.FunctionType.AoFunction)
            lblMode.Text = "Idle"
            ulstat = MccDaq.MccService.WinBufFreeEx(MHandle) ' Free up memory for use by other programs
        End If

    End Sub

    Private Sub btnEnd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnEnd.Click
        'Stop everything if not already stopped, release the memory, then end the program
        btnStartStop.Text = "Start"
        Status = False
        ulstat = Daqboard.StopBackground(MccDaq.FunctionType.AoFunction)
        lblMode.Text = "Idle"
        ulstat = MccDaq.MccService.WinBufFreeEx(MHandle) ' Free up memory for use by other programs
        End

    End Sub

    Public Sub errhandler(ByVal ulstat As MccDaq.ErrorInfo)
        'Generic UL error handler
        tmrOutScan.Enabled = False
        MessageBox.Show(ulstat.Message, "Universal Library Error ", MessageBoxButtons.OK, MessageBoxIcon.Error)
        lblMode.Text = "Idle"
        btnStartStop.Text = "Start"
        ulstat = Daqboard.StopBackground(MccDaq.FunctionType.AiFunction)
        ulstat = MccDaq.MccService.WinBufFreeEx(MHandle) ' Free up memory for use by other programs

    End Sub

    'From here down is just some house and error checking for the application
    Private Sub txtPointsPerWaveform_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtPointsPerWaveform.KeyPress

        KeyPressService(sender, e, AllowedCharactersInt)
    End Sub

    Private Sub txtAORate_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtAORate.KeyPress

        KeyPressService(sender, e, AllowedCharactersInt)
    End Sub

    Private Sub txtDutyCycle_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtDutyCycle.KeyPress

        KeyPressService(sender, e, AllowedCharactersInt)
    End Sub

    Private Sub txtAmplitude_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtAmplitude.KeyPress

        KeyPressService(sender, e, AllowedCharactersFloat)
    End Sub

    Private Sub txtOffset_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtOffset.KeyPress

        KeyPressService(sender, e, AllowedCharactersInt)
    End Sub

    Private Sub KeyPressService(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs, ByVal charSet As String)

        If Not charSet.Contains(e.KeyChar) AndAlso e.KeyChar <> ChrW(Keys.Back) Then
            e.Handled = True
        End If

    End Sub

    Private Sub DisableObjects()
        rbSineWave.Enabled = False
        rbSquareWave.Enabled = False
        rbRampWave.Enabled = False
        rbTriangleWave.Enabled = False
        rbNoiseWave.Enabled = False
        chkAOBackground.Enabled = False
        chkAOContinuous.Enabled = False
        chkExtClock.Enabled = False
        chkExtTrigger.Enabled = False
        nudChannelNumber.Enabled = False
        txtPointsPerWaveform.Enabled = False
        txtAmplitude.Enabled = False
        txtOffset.Enabled = False
        txtAORate.Enabled = False
        txtDutyCycle.Enabled = False
        btnEnd.Enabled = False
    End Sub

    Private Sub EnableObjects()
        rbSineWave.Enabled = True
        rbSquareWave.Enabled = True
        rbRampWave.Enabled = True
        rbTriangleWave.Enabled = True
        rbNoiseWave.Enabled = True
        chkAOBackground.Enabled = True
        chkAOContinuous.Enabled = True
        chkExtClock.Enabled = True
        chkExtTrigger.Enabled = True
        nudChannelNumber.Enabled = True
        txtPointsPerWaveform.Enabled = True
        txtAmplitude.Enabled = True
        txtOffset.Enabled = True
        txtAORate.Enabled = True
        txtDutyCycle.Enabled = True
        btnEnd.Enabled = True
    End Sub

End Class
