'The attached Code or Example is provided As Is.  
'It has not been tested or validated as a product, 
'for use in a deployed application or system, or for use in hazardous environments.  
'You assume all risks for use of the Code or Example.

Public Class Form1
    Dim inventory As MccDaq.DaqDeviceDescriptor()
    Public Daqboard As New MccDaq.MccBoard()
    Dim ulstat As MccDaq.ErrorInfo


    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'First Lets make sure there's some kind of 1608G plugged in:
        MccDaq.DaqDeviceManager.IgnoreInstaCal() 'don't use information from InstaCal.

        System.Windows.Forms.Cursor.Current = Cursors.WaitCursor 'change cursor to wait.
        Dim Boardfound As Boolean = False

        'load all the boards it can find
        inventory = MccDaq.DaqDeviceManager.GetDaqDeviceInventory(MccDaq.DaqDeviceInterface.Any)

        Dim numDevDiscovered As Integer = inventory.Length 'how many was that?

        If numDevDiscovered > 0 Then
            For boardNum As Integer = 0 To numDevDiscovered - 1

                Try
                    '    Create a new MccBoard object for Board and assign a board number 
                    '    to the specified DAQ device with CreateDaqDevice()
                    Daqboard = MccDaq.DaqDeviceManager.CreateDaqDevice(boardNum, inventory(boardNum))

                    If Daqboard.BoardName.Contains("1608G") Then
                        Boardfound = True
                        Daqboard.FlashLED()
                        Exit For
                    Else
                        MccDaq.DaqDeviceManager.ReleaseDaqDevice(Daqboard)
                    End If
                Catch ule As MccDaq.ULException
                    MsgBox(ule.ErrorInfo.Message)
                End Try
            Next
        End If


        If Boardfound = False Then
            MsgBox("No USB-1608G series board found in system.  Please run InstaCal.", MsgBoxStyle.Critical, "No Board detected")
            End
        End If

        Dim mystring As String = Daqboard.BoardName.Substring(0, Daqboard.BoardName.Trim.Length) + _
            " found as board number: " + Daqboard.BoardNum.ToString
        Me.Text = mystring

    End Sub

    Private Sub Button6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button6.Click
        End
    End Sub

    Private Sub tmrDigitalIn_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tmrDigitalIn.Tick
        Dim PortVal As Short

        ulstat = Daqboard.DIn(MccDaq.DigitalPortType.AuxPort, PortVal)
        If ulstat.Value <> 0 Then Call errhandler(ulstat)

        Led0.Value = PortVal And 2 ^ 0
        Led1.Value = PortVal And 2 ^ 1
        Led2.Value = PortVal And 2 ^ 2
        Led3.Value = PortVal And 2 ^ 3
        Led4.Value = PortVal And 2 ^ 4
        Led5.Value = PortVal And 2 ^ 5
        Led6.Value = PortVal And 2 ^ 6
        Led7.Value = PortVal And 2 ^ 7
    End Sub

    Public Sub errhandler(ByVal ulstat As MccDaq.ErrorInfo)
        'Generic UL error handler
        tmrDigitalIn.Enabled = False
        MessageBox.Show(ulstat.Message, "Universal Library Error ", MessageBoxButtons.OK, MessageBoxIcon.Error)

    End Sub
End Class
