'The attached Code or Example is provided As Is.  
'It has not been tested or validated as a product, 
'for use in a deployed application or system, or for use in hazardous environments.  
'You assume all risks for use of the Code or Example.

Public Class Form1
    Dim inventory As MccDaq.DaqDeviceDescriptor()
    Public Daqboard As New MccDaq.MccBoard()
    Dim ulstat As MccDaq.ErrorInfo
    Dim PortVal As UShort = 0

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'First Lets make sure there's some kind of 1608G plugged in:
        MccDaq.DaqDeviceManager.IgnoreInstaCal() 'don't use information from InstaCal.

        System.Windows.Forms.Cursor.Current = Cursors.WaitCursor 'change cursor to wait.
        Dim Boardfound As Boolean = False

        'load all the boards it can find
        inventory = MccDaq.DaqDeviceManager.GetDaqDeviceInventory(MccDaq.DaqDeviceInterface.Any)

        Dim numDevDiscovered As Integer = inventory.Length 'how many was that?

        If numDevDiscovered > 0 Then
            For boardNum As Integer = 0 To numDevDiscovered - 1

                Try
                    '    Create a new MccBoard object for Board and assign a board number 
                    '    to the specified DAQ device with CreateDaqDevice()
                    Daqboard = MccDaq.DaqDeviceManager.CreateDaqDevice(boardNum, inventory(boardNum))

                    If Daqboard.BoardName.Contains("1608G") Then
                        Boardfound = True
                        Daqboard.FlashLED()
                        Exit For
                    Else
                        MccDaq.DaqDeviceManager.ReleaseDaqDevice(Daqboard)
                    End If
                Catch ule As MccDaq.ULException
                    MsgBox(ule.ErrorInfo.Message)
                End Try
            Next
        End If

        If Boardfound = False Then
            MsgBox("No USB-1608G series board found in system.  Please run InstaCal.", MsgBoxStyle.Critical, "No Board detected")
            End
        End If

        Dim mystring As String = Daqboard.BoardName.Substring(0, Daqboard.BoardName.Trim.Length) + _
            " found as board number: " + Daqboard.BoardNum.ToString
        Me.Text = mystring

        'Configure the Port (all 8 bits) to output.
        ulstat = Daqboard.DConfigPort(MccDaq.DigitalPortType.AuxPort, MccDaq.DigitalPortDirection.DigitalOut)
        If ulstat.Value <> 0 Then Call errhandler(ulstat)
    End Sub
    Public Sub errhandler(ByVal ulstat As MccDaq.ErrorInfo)
        'Generic UL error handler
        MessageBox.Show(ulstat.Message, "Universal Library Error ", _
                   MessageBoxButtons.OK, MessageBoxIcon.Error)

    End Sub

    Private Sub Button6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button6.Click
        ulstat = Daqboard.DOut(MccDaq.DigitalPortType.AuxPort, 0) 'turn all bits back off.
        If ulstat.Value <> 0 Then Call errhandler(ulstat)
        End
    End Sub

    Public Sub SetBitVal(ByVal sender As System.Object)
        'So as not to repeat the same routine 8 times,  This subroutine is called each time the user clicks on a
        'specific bit's related checkbox event.  This way there is only one place to look for and modify the DBitOut method
        '
        'First, parse the last character of the objects name which is the bit number. 
        'Use the bitnum to find out if the objects text is "Off" or "On".  Change the label of the object from Off to On or 
        'On to Off, and change the state of the related bit appropriately.
        Dim bitname, bitnumber As String

        With sender 'sender is the checkbox that is used to change the state of the bit.
            bitname = .name
            bitnumber = bitname.Substring(6, 1).Trim
            Dim bitnum As Integer
            bitnum = Val(bitnumber)
            If .text = "Off" Then
                .text = "On"
                PortVal = PortVal + 2 ^ bitnum
            Else
                .text = "Off"
                PortVal = PortVal - 2 ^ bitnum
            End If
        End With
        lblPortVal.Text = "Port Value:  " + PortVal.ToString
        ulstat = Daqboard.DOut(MccDaq.DigitalPortType.AuxPort, PortVal)
        If ulstat.Value <> 0 Then Call errhandler(ulstat)

    End Sub

    Private Sub chkBit0_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkBit0.CheckedChanged
        SetBitVal(chkBit0)
    End Sub

    Private Sub chkBit1_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkBit1.CheckedChanged
        SetBitVal(chkBit1)
    End Sub

    Private Sub chkBit2_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkBit2.CheckedChanged
        SetBitVal(chkBit2)
    End Sub

    Private Sub chkBit3_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles chkBit3.CheckStateChanged
        SetBitVal(chkBit3)
    End Sub

    Private Sub chkBit4_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles chkBit4.CheckedChanged
        SetBitVal(chkBit4)
    End Sub

    Private Sub chkBit5_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles chkBit5.CheckedChanged
        SetBitVal(chkBit5)
    End Sub

    Private Sub chkBit6_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles chkBit6.CheckedChanged
        SetBitVal(chkBit6)
    End Sub

    Private Sub chkBit7_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles chkBit7.CheckedChanged
        SetBitVal(chkBit7)
    End Sub
End Class
