﻿'The attached Code or Example is provided As Is.  
'It has not been tested or validated as a product, 
'for use in a deployed application or system, or for use in hazardous environments.  
'You assume all risks for use of the Code or Example.

Public Class Form1
    Dim inventory As MccDaq.DaqDeviceDescriptor()
    Public Daqboard As New MccDaq.MccBoard()
    Dim ulstat As MccDaq.ErrorInfo

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'First Lets make sure there's some kind of 1608G plugged in:
        MccDaq.DaqDeviceManager.IgnoreInstaCal() 'don't use information from InstaCal.

        System.Windows.Forms.Cursor.Current = Cursors.WaitCursor 'change cursor to wait.
        Dim Boardfound As Boolean = False

        'load all the boards it can find
        inventory = MccDaq.DaqDeviceManager.GetDaqDeviceInventory(MccDaq.DaqDeviceInterface.Any)

        Dim numDevDiscovered As Integer = inventory.Length 'how many was that?

        If numDevDiscovered > 0 Then
            For boardNum As Integer = 0 To numDevDiscovered - 1

                Try
                    '    Create a new MccBoard object for Board and assign a board number 
                    '    to the specified DAQ device with CreateDaqDevice()
                    Daqboard = MccDaq.DaqDeviceManager.CreateDaqDevice(boardNum, inventory(boardNum))

                    If Daqboard.BoardName.Contains("1608G") Then
                        Boardfound = True
                        Daqboard.FlashLED()
                        Exit For
                    Else
                        MccDaq.DaqDeviceManager.ReleaseDaqDevice(Daqboard)
                    End If
                Catch ule As MccDaq.ULException
                    MsgBox(ule.ErrorInfo.Message)
                End Try
            Next
        End If

        If Boardfound = False Then
            MsgBox("No USB-1608G series board found in system.  Please run InstaCal.", MsgBoxStyle.Critical, "No Board detected")
            End
        End If

        Dim mystring As String = Daqboard.BoardName.Substring(0, Daqboard.BoardName.Trim.Length) + _
            " found as board number: " + Daqboard.BoardNum.ToString
        Me.Text = mystring

        Me.Show()
        Me.Refresh()

        'Configure the Port (all 8 bits) to output.
        ulstat = Daqboard.DConfigPort(MccDaq.DigitalPortType.AuxPort, MccDaq.DigitalPortDirection.DigitalOut)
        If ulstat.Value <> 0 Then
            MessageBox.Show(ulstat.Message, "Universal Library Error ", _
                   MessageBoxButtons.OK, MessageBoxIcon.Error)
            End
        End If

        'you will need an oscilloscope to view the output of this. 
        'To stop it I had to add Application.DoEvents so the program will respond to the End button. 
        'This does take up some loop time, but I found it to have a negligible effect.
        'I wanted to run the port as fast as possible.  On my computer, I was able to generate a 2KHz square wave
        'which equates to 4000 updates per second.
        Dim x As Long
        Dim y As Short
        Do While (True)
            x += 1
            y = x Mod 2
            ulstat = Daqboard.DOut(MccDaq.DigitalPortType.AuxPort, y)
            Application.DoEvents()
        Loop
    End Sub

    Private Sub btnEnd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnEnd.Click
        End
    End Sub
End Class
