﻿Public Class Form1
    Dim inventory As MccDaq.DaqDeviceDescriptor()
    Public Daqboard As New MccDaq.MccBoard()
    Dim ulstat As MccDaq.ErrorInfo

    Const AllowedCharactersInt As String = "0123456789"
    Const AllowedCharactersFloat As String = "0123456789."

    Private Sub KeyPressService(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs, ByVal charSet As String)
        'this sub is here to make sure the user only enters an allowed character based upon the constants above.
        'See the _KeyPress subs at the end for implementation.
        If Not charSet.Contains(e.KeyChar) AndAlso e.KeyChar <> ChrW(Keys.Back) Then
            e.Handled = True
        End If
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'First Lets make sure there's some kind of 1608G plugged in:
        MccDaq.DaqDeviceManager.IgnoreInstaCal() 'don't use information from InstaCal.

        System.Windows.Forms.Cursor.Current = Cursors.WaitCursor 'change cursor to wait.
        Dim Boardfound As Boolean = False

        'load all the boards it can find
        inventory = MccDaq.DaqDeviceManager.GetDaqDeviceInventory(MccDaq.DaqDeviceInterface.Any)

        Dim numDevDiscovered As Integer = inventory.Length 'how many was that?

        If numDevDiscovered > 0 Then
            For boardNum As Integer = 0 To numDevDiscovered - 1

                Try
                    '    Create a new MccBoard object for Board and assign a board number 
                    '    to the specified DAQ device with CreateDaqDevice()
                    Daqboard = MccDaq.DaqDeviceManager.CreateDaqDevice(boardNum, inventory(boardNum))

                    If Daqboard.BoardName.Contains("1608G") Then
                        Boardfound = True
                        Daqboard.FlashLED()
                        Exit For
                    Else
                        MccDaq.DaqDeviceManager.ReleaseDaqDevice(Daqboard)
                    End If
                Catch ule As MccDaq.ULException
                    MsgBox(ule.ErrorInfo.Message)
                End Try
            Next
        End If

        If Boardfound = False Then
            MsgBox("No USB-1608G series board found in system.  Please run InstaCal.", MsgBoxStyle.Critical, "No Board detected")
            End
        End If

        Dim mystring As String = Daqboard.BoardName.Substring(0, Daqboard.BoardName.Trim.Length) + _
            " found as board number: " + Daqboard.BoardNum.ToString
        Me.Text = mystring

        cmboIdleState.Items.Add("Low")
        cmboIdleState.Items.Add("High")
        cmboIdleState.SelectedIndex = 0

    End Sub

    Private Sub btnEnd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnEnd.Click
        'Stop the timer output on exit
        ulstat = Daqboard.PulseOutStop(0)
        End

    End Sub

    Private Sub txtDutyCycle_KeyPress(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtDutyCycle.KeyPress
        KeyPressService(sender, e, AllowedCharactersFloat)
    End Sub

    Private Sub txtPeriod_KeyPress(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtPeriod.KeyPress
        KeyPressService(sender, e, AllowedCharactersFloat)
    End Sub

    Private Sub txtPulseCount_KeyPress(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtPulseCount.KeyPress
        KeyPressService(sender, e, AllowedCharactersInt)
    End Sub

    Private Sub txtInitialDelay_KeyPress(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtInitialDelay.KeyPress
        KeyPressService(sender, e, AllowedCharactersFloat)
    End Sub

    Private Sub btnStartStop_Click(sender As System.Object, e As System.EventArgs) Handles btnStartStop.Click
        If btnStartStop.Text = "Start" Then
            btnStartStop.Text = "Stop"
            lblStatus1.Text = "Running"

            'setup and start the timer.
            Dim dblFrequency As Double = Convert.ToDouble(txtPeriod.Text)
            Dim dblDutyCycle As Double = Convert.ToDouble(txtDutyCycle.Text) / 100
            Dim intPulseCount As Int32 = Convert.ToInt32(txtPulseCount.Text)
            Dim dblInitialDelay As Double = Convert.ToDouble(txtInitialDelay.Text)
            Dim IdleState As MccDaq.IdleState
            Select Case (cmboIdleState.SelectedIndex)
                Case 0
                    IdleState = MccDaq.IdleState.Low
                Case 1
                    IdleState = MccDaq.IdleState.High
            End Select

            ulstat = Daqboard.PulseOutStart(0, dblFrequency, dblDutyCycle, intPulseCount, dblInitialDelay, IdleState, MccDaq.PulseOutOptions.Default)
            lblStatus.Text = "Status:  " + ulstat.Message
            
        Else
            btnStartStop.Text = "Start"
            lblStatus1.Text = "Idle"
             'Stop the timer.
            ulstat = Daqboard.PulseOutStop(0)
            lblStatus.Text = "Status:  " + ulstat.Message
        End If
    End Sub
End Class
