/**********************************************************
expandable_section.js
Version 1.2
Created: May 06, 2002
Author: Mitch Wilson
Revised: Jan. 24, 2005
Author: Greg Bueno

[Usage]
- <body bgcolor="#ffffff" onLoad="InitExpandableObjects();";>
- <link rel="StyleSheet" type="text/css" href="expandable_section.css">
- <script src="expandable_section.js" type="text/javascript"></script>
- <div id="NAME_OF_SECTION">
  <p class="expandable-head-close">Clickable text</p>
  <p class="expandable-section-close">Hidden text</p>
  </div>
		
[Required Files]								
- arrow_close.gif
- arrow_open.gif

[Notes]
- HomeSite snippets available
  
[History]
- Version 1.2 Jan. 24, 2005 - Rewritten to reduce attribute clutter in HTML elements.
- Version 1.1 May 06, 2003 - Reduced arguments from two to one
- Version 1.0 February 18, 2003 - Released
***********************************************************/

/*
Configure default style class names.
In case the user renames the class names, these configuration values may be changed
without interfering with any functions.
*/
//Name of class when expandable heading is closed.
headCloseClass = "expandable-head-close";
//Name of class when expandable heading is open.
headOpenClass = "expandable-head-open";
//Name of class when expandable section is closed.
sectionCloseClass = "expandable-section-close";
//Name of class when expandable section is open.
sectionOpenClass = "expandable-section-open";

/*
FUNCTION:
object ExpandableObject(string object name);

USAGE:
ObjectName = new ExpandableObject("DIV ID");

DESCRIPTION:
Creates an expandable object, which references HTML collections
responsible for toggling the visibility of an expandable sections.

RETURN VALUE:
An object.
*/
function ExpandableObject(objectName)
{
	//Save the object name as property. Just in case.
	this.objectName = objectName;
	//Retrieve element with the class named "headCloseClass".
	this.heading = GetExpandableObjectByClass(objectName, headCloseClass);
	//Retrieve element with the class named "sectionCloseClass".
	this.heading.section = GetExpandableObjectByClass(objectName, sectionCloseClass);
	
	//Assign a mouse event to the heading element to toggle the expandable section.
	this.heading.onclick = function()
	{
		//If the section is closed, open it.
		if (this.className==headCloseClass)
		{
			//Change the heading's CSS class to "headOpenClass".
			this.className = headOpenClass;
			//Change the section's CSS class to "sectionOpenClass".
			this.section.className = sectionOpenClass;
		}
		//If the section is opened, close it.
		else if (this.className==headOpenClass)
		{
			//Change the heading's CSS class to "headCloseClass".
			this.className = headCloseClass;
			//Change the section's CSS class to "sectionCloseClass".
			this.section.className = sectionCloseClass;
		}
	}
}

/*
FUNCTION:
object GetExpandableObjectByClass(string element id, string class name);

USAGE:
None. This function is private in scope.

DESCRIPTION:
Retrieves the HTML collection of the element with the given ID,
then finds a child node of that collection containing the given class name.

RETURN VALUE:
HTML collection.
*/
function GetExpandableObjectByClass(section, className)
{
	//Initialize object.
	var object = '';
	//Retrieve HTML collection with the given ID.
	sectionObject = document.getElementById(section);
	//Cycle through all child nodes of the retrieved collection.
	for (n=0; n<sectionObject.childNodes.length; n++)
	{
		//Create an alias for the child node for easier reading.
		nodes = sectionObject.childNodes[n];
		//nodeType 1 is an HTML element, so check for it.
		if (nodes.nodeType==1)
		{
			//Create a regular expression with the given class name.
			eval('re = /' + className + '/');
			//alert(typeof nodes.attributes[0].name);
			for (a=0; a<nodes.attributes.length; a++)
			{
				if (typeof nodes.attributes[a].name=="string")
				{
					//If a class attribute exists and matches the node, return this element as an object.
					if (nodes.attributes[a].name=="class" && (String(nodes.className).match(re)))
					{
						object = nodes;
					}
				}
				else if (typeof nodes.attributes[a]=="object")
				{
					if (String(nodes.attributes[a]).match(re))
					{
						object = nodes; 
					}
				}
			}
		}
	}
	return object;
}

/*
FUNCTION:
void InitExpandableObjects(void);

USAGE:
<body onload="InitExpandableObjects();">

DESCRIPTION:
Retrieves all DIV elements, extracts any with IDs and creates expandable objects for each.

RETURN VALUE:
Expandable objects.
*/
function InitExpandableObjects()
{
	//Regular expressions to handle illegal characters in DIV IDs.
	//The IDs will be used as placeholder object names and as an argument
	//in our object constructor.
	re_space = /\s/g; //Find space character.
	re_illegal = /([\(\)\<\>\,\;\:\\\/\"\'\[\]])/g; //Find reserved characters.
	
	//Retrieve all elements named DIV.
	element = document.getElementsByTagName("DIV");
	//Cycle through all DIV elements.
	for (e=0; e<element.length; e++)
	{
		//Process if an ID exists.
		if (element[e].id)
		{
			//Process the ID string for reserved characters and spaces.
			//Appending "_obj" to the object name distinguishes the object in IE
			objectName = String(element[e].id) + "_obj";
			//Replace spaces with underscores
			objectName = objectName.replace(re_space, "_");
			//Get rid of reserved characters.
			objectName = objectName.replace(re_illegal, "");

			idName = String(element[e].id);
			//Escape reserved characters
			idName = idName.replace(re_illegal, "\\$1");
			
			//Create the object.
			//alert(objectName + " = new ExpandableObject('" + idName + "');");
			eval(objectName + " = new ExpandableObject('" + idName + "');");
		}
	}
}
